/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.Server;
import noppes.npcs.blocks.CustomBlockPortal;
import noppes.npcs.constants.EnumPacketClient;

public class CustomTileEntityPortal
extends TileEntityEndPortal {
    public int dimensionId = 100;
    public int homeDimensionId = 0;
    public float speed = 800.0f;
    public float alpha = 0.5f;
    public final int[] posTp = new int[]{0, -1, 0};
    public final int[] posHomeTp = new int[]{0, -1, 0};
    private ResourceLocation SKY_TEXTURE;
    private ResourceLocation PORTAL_TEXTURE;
    private int type = 3;

    public ResourceLocation getPortalTexture() {
        IBlockState state;
        if (this.PORTAL_TEXTURE == null && this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof CustomBlockPortal) {
            this.PORTAL_TEXTURE = new ResourceLocation("customnpcs", "textures/environment/custom_" + ((CustomBlockPortal)state.func_177230_c()).getCustomName() + "_portal.png");
        }
        if (this.PORTAL_TEXTURE != null) {
            return this.PORTAL_TEXTURE;
        }
        return new ResourceLocation("textures/entity/end_portal.png");
    }

    public BlockPos getPosTp(boolean isHome) {
        BlockPos p;
        int[] pos = null;
        WorldServer world = null;
        if (isHome) {
            if (DimensionManager.isDimensionRegistered((int)this.homeDimensionId)) {
                pos = this.posHomeTp;
                if (this.field_145850_b.func_73046_m() != null) {
                    world = this.field_145850_b.func_73046_m().func_71218_a(this.homeDimensionId);
                } else if (CustomNpcs.Server != null) {
                    world = CustomNpcs.Server.func_71218_a(this.homeDimensionId);
                }
            }
        } else if (DimensionManager.isDimensionRegistered((int)this.dimensionId)) {
            pos = this.posTp;
            if (this.field_145850_b.func_73046_m() != null) {
                world = this.field_145850_b.func_73046_m().func_71218_a(this.dimensionId);
            } else if (CustomNpcs.Server != null) {
                world = CustomNpcs.Server.func_71218_a(this.dimensionId);
            }
        }
        if ((pos == null || pos[1] < 0) && world != null) {
            p = world.func_180504_m();
            if (p == null) {
                p = world.func_175694_M();
            }
            pos[0] = p.func_177958_n();
            pos[1] = p.func_177956_o();
            pos[2] = p.func_177952_p();
        }
        if (pos == null) {
            pos = new int[]{0, 70, 0};
        }
        p = null;
        if (world != null) {
            if (!world.func_175623_d(new BlockPos(pos[0], pos[1], pos[2]))) {
                p = world.func_175672_r(new BlockPos(pos[0], pos[1], pos[2]));
            } else if (!world.func_175623_d(new BlockPos(pos[0], pos[1] + 1, pos[2]))) {
                p = new BlockPos(pos[0], pos[1], pos[2]);
                while (world.func_175623_d(p) && p.func_177956_o() > 0) {
                    p = p.func_177977_b();
                }
                if (p.func_177956_o() == 0) {
                    p = world.func_175672_r(p);
                }
            }
            if (p != null) {
                pos[0] = p.func_177958_n();
                pos[1] = p.func_177956_o();
                pos[2] = p.func_177952_p();
            }
        }
        return p;
    }

    public ResourceLocation getSkyTexture() {
        IBlockState state;
        if (this.SKY_TEXTURE == null && this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof CustomBlockPortal) {
            this.SKY_TEXTURE = new ResourceLocation("customnpcs", "textures/environment/custom_" + ((CustomBlockPortal)state.func_177230_c()).getCustomName() + "_sky.png");
        }
        if (this.SKY_TEXTURE != null) {
            return this.SKY_TEXTURE;
        }
        return new ResourceLocation("textures/environment/end_sky.png");
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (!compound.func_150297_b("DimensionID", 3)) {
            CustomNpcs.proxy.fixTileEntityData((TileEntity)this);
            return;
        }
        this.dimensionId = compound.func_74762_e("DimensionID");
        this.homeDimensionId = compound.func_74762_e("HomeDimensionID");
        this.speed = compound.func_74760_g("SecondSpeed");
        int[] p = compound.func_74759_k("HomePosition");
        if (p.length >= 3) {
            this.posHomeTp[0] = p[0];
            this.posHomeTp[1] = p[1];
            this.posHomeTp[2] = p[2];
        }
        if ((p = compound.func_74759_k("TpPosition")).length >= 3) {
            this.posTp[0] = p[0];
            this.posTp[1] = p[1];
            this.posTp[2] = p[2];
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_184313_a(@Nonnull EnumFacing facing) {
        IBlockState state;
        if (this.type == 3 && this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof CustomBlockPortal) {
            this.type = state.func_177230_c().func_176201_c(state);
        }
        switch (this.type) {
            case 1: {
                return facing == EnumFacing.SOUTH || facing == EnumFacing.NORTH;
            }
            case 2: {
                return facing == EnumFacing.WEST || facing == EnumFacing.EAST;
            }
        }
        return facing == EnumFacing.UP || facing == EnumFacing.DOWN;
    }

    public void updateToClient() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        Server.sendToAll(CustomNpcs.Server, EnumPacketClient.SET_TILE_DATA, this.func_189515_b(new NBTTagCompound()));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("DimensionID", this.dimensionId);
        compound.func_74768_a("HomeDimensionID", this.homeDimensionId);
        compound.func_74776_a("SecondSpeed", this.speed);
        compound.func_74783_a("HomePosition", this.posHomeTp);
        compound.func_74783_a("TpPosition", this.posTp);
        return compound;
    }
}

